C      *****************************************************************
C      * Subroutine FMovIon                                            *
C      * Calculates the new known totals for components in each layer  *
C      * given the amount of each component that moves between the     *
C      * layers.  The sign of the quantity that moves determines the   *
C      * direction of movement.  Positive is down, negative is up.     *
C      * This routine used to check for resulting negative values for  *
C      * KT.  It used to print out an error message and return a flag  *
C      * if any KT other than hydrogen was negative.  At present,      *
C      * June 1994, this code has been commented out.                  *
C      *                                                               *
C      * Variables:                                                    *
C      * C         -Local - Component index.  Unitless.                *
C      * GoAhead   -Output- Indicates whether any errors were found.   *
C      *                    (GoAhead=1, no errors found; GoAhead=0,    *
C      *                    errors found.)  Unitless.                  *
C      * Dummy     -Local - A dummy variable used to hold the screen   *
C      *                    to allow user to read the error message.   *
C      *                    Unitless.                                  *
C      * HIndex    -Local - The hydrogen ion index.  Unitless.         *
C      * KT        -In/Out- A matrix, of size NComp by NLayer, of the  *
C      *                    known total amount for each component, for *
C      *                    each layer.  The total includes the amount *
C      *                    of the component as a free component and as*
C      *                    part of all dependent species.  Units are  *
C      *                    mol.                                       *
C      *                    (Common block VModel, file VModel.f)       *
C      * LNum      -Local - Layer index.  Unitless.                    *
C      * MovComp   -Input - A matrix, of size NComp by NLayers+1,      *
C      *                    that contains the amount of each component *
C      *                    moved in each flux.  If the amount is      *
C      *                    positive the component moves from the layer*
C      *                    with the same number as the flux to layer  *
C      *                    flux+1.  If the amount is negative the     *
C      *                    component moves from layer flux to flux-1. *
C      *                    Units are mol.                             *
C      *                    (Common block VModel, file VModel.f)       *
C      * Name      -Local - Used for passing data to WhereIs function. *
C      *                    Unitless.                                  *
C      * NComp     -Input - The number of components in the system.    *
C      *                    Unitless.                                  *
C      *                    (Common block VModel, file VModel.f)       *
C      * NLayers   -Input - The number of soil layers in the system.   *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Unitless.         *
C      *                    (Common block VPos, file VModel.f)         *
C      * WhereIs   -Fcn   - Returns the index of requested species. If *
C      *                    the species is not found a -1 is returned. *
C      *                    Unitless.                                  *
C      *****************************************************************
       SUBROUTINE FMOVION(GOAHEAD)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
       INTEGER C, GOAHEAD, HINDEX, LNUM, WHEREIS
							CHARACTER DUMMY
							CHARACTER*8 NAME

C      *-----------------------------------------------------------*
C      * Initialize variable to indicate that all KTs are positive *
C      *-----------------------------------------------------------*
       GOAHEAD = 1

C      *-----------------------------*
C      * Find the index for hydrogen *
C      *-----------------------------*
       NAME = 'H'
       HINDEX = WHEREIS(NAME)

C      *----------------------*
C      * Loop over each layer *
C      *----------------------*
	      DO 100 LNUM=1, NLAYERS
	         DO 110 C = 1, NCOMP
C            *----------------------------------------------------*
C            * The new KT is the old KT minus what is leaving the *
C            * layer plus what is entering the layer.             *
C            *----------------------------------------------------*
		         	 KT(C,LNUM) = KT(C,LNUM) - MOVCOMP(C,LNUM) + 
     >                                           MOVCOMP(C,LNUM-1)

C            *--------------------------------------------------------*
C            * If the new value for the known total is less than zero *
C            * for any component except hydrogen, output a message and*
C            * indicate to calling routine.  (Hydrogen's KT can be    *
C            * negative to allow pHs above 7.)                        *
C            *--------------------------------------------------------*
c--	            IF ((KT(C,LNUM).LT.0).AND.(C.NE.HINDEX)) THEN
c--			             WRITE(6,*)
c--	            			WRITE(6,1111) C, LNUM, KT(C,LNUM)
c-- 1111           FORMAT(' ',
c--     >          '-->ERROR IN ROUTINE FMovIon, FILE: FMovIOn.f',
c--     >          'KT is negative for a component other than H',
c--     >          /,' ', 'KT(',I2,',',I2,') = ',F10.5,/,' ',
c--     >          'Press any letter then return to exit gracefully')
c--	               READ(6,*) DUMMY
c--                GOAHEAD = 0	 
c--	            ENDIF
  110     CONTINUE
  100  CONTINUE

       RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
